﻿using System;
using System.Reflection;
using System.Threading;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.VBECS.Communication.Channels;
using gov.va.med.VBECS.Communication.Clients;

namespace gov.va.med.VBECS.Communication.Common
{
    /// <summary>
    /// Simple pinger object 
    /// </summary>
    public class Pinger : IPinger
    {
        private IClient _messager;

        /// <summary>
        /// Ping time out in minutes.
        /// </summary>
        private const int PingTimeout = 1;

        /// <summary>
        /// This timer is used to send PingMessage messages to server periodically.
        /// </summary>
        private readonly Timer _pingTimer;

        // Logger
        private readonly ILogger _logger =
            LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// Constructor
        /// </summary>
        public Pinger()
        {
            _pingTimer = new Timer(handle_ping_time_callback, null, 30000, 30000);
        }

        /// <summary>
        /// Starts pinger object
        /// </summary>
        /// <param name="messager">Messanger current pinger belongs to</param>
        public void Start(IMessager messager)
        {
            _messager = (IClient)messager;
            //Callback will be called in 100 millisecond with subsequent 30 seconds interval calls.
            _pingTimer.Change(100, 30000);   
        }

        /// <summary>
        /// This method is called by hosting messenger when ping message is received.
        /// </summary>
        /// <param name="msg">Ping message</param>
        public void PingMessageReceived(IPingMessage msg)
        {
            //Default pinger (this one) does nothing here.
        }

        /// <summary>
        /// Stops pinger object
        /// </summary>
        public void Stop()
        {
            _pingTimer.Change(Timeout.Infinite, Timeout.Infinite);
        }

        private void handle_ping_time_callback(object state)
        {
            if (_messager == null || _messager.CommunicationStatus != CommunicationStatus.Connected)
            {
                return;
            }

            try
            {
                var lastMinute = DateTime.Now.AddMinutes(PingTimeout * -1);
                if (_messager.LastReceivedTime > lastMinute ||
                    _messager.LastSentTime > lastMinute)
                {
                    return;
                }

                _messager.Send(new PingMessage());
            }
            catch (Exception e)
            {
                _logger.Error(e.Message, e);
            }
        }
    }
}
